//
//  YHAppointItem.swift
//  galaxy
//
//  Created by edy on 2024/8/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHAppointItemType: Int {
    // 未知
    case none = 0
    // 赴港办证
    case goHKMakeCertificate = 1
    // 温馨提示
    case warmTips = 2
    // 无需预约办证成员（未满11岁）
    case noNeedMakeCertificateMembers = 3
    // 赴港激活签证
    case activeVisa = 4
    // 请您确认第X批赴港信息
    case confirmGoHKInfo = 5
    // 待预约赴港成员
    case needReAppointMembers = 6
    // 赴港办理抢号中批次
    case grabingNumberBatch = 7
    // 赴港办理已抢号批次
    case haveGrabedNumberBatch = 8
    
}

class YHAppointItem {
    var itemIndex: Int = 0
    var type: YHAppointItemType = .none
    var model: YHSelectGroupMemberModel? // type = .confirmGoHKInfo 时候的赋值
    // 办证地点选择列表
    var placeList: [YHMakeCertificatePlaceModel] = []
    
    var arrHkHolidays: [String]? // 香港法定节假日
    
    init(type: YHAppointItemType) {
        self.type = type
    }
}

class YHSelectGroupMemberModel {
    // 赴港激活签证的申请人信息
    var arr: [YHHKMemberModel] = []
    
    // 赴港办证时间类型
    var dateTye: Int = 0 // 0 - 具体日期  1-具体时段
    
    // 具体日期
    var detailDateStr: String = ""
    
    // 开始时间
    var startDateStr: String = ""
    
    // 结束时间
    var endDateStr: String = ""
    
    // 办证地点
    var hkPlace: YHMakeCertificatePlaceModel = YHMakeCertificatePlaceModel()
    
    // 需要检测日期和办证地点是否选择
    var isNeedCheck = false
    
    // 是否统一赴港
    var isAllMembersGoHK: Bool = false
    
    // 是否显示重新预约人员名单
    var isShowReAppointView: Bool = false
    
    //
    var isWillVisitHkGalaxyBay: Int = 0  // 0没有选择1是2否

}
